package unificationSolver;


public class AndSolutionNode extends AbstractSolutionNode 
{
	private AbstractSolutionNode headSolutionNode = null;
	private AbstractSolutionNode tailSolutionNode = null;
	
	private AbstractOperator operatorTail = null;

	public AndSolutionNode(And goal, RuleSet rules, SubstitutionSet parentSolution) throws CloneNotSupportedException
	{
		super(goal, rules, parentSolution);
		headSolutionNode = goal.getFirstOperand().getSolver(rules, parentSolution);
		operatorTail = goal.getOperatorTail();
		
	}

	
	protected AbstractSolutionNode getHeadSolutionNode(){
		return headSolutionNode;
	}
	
	protected AbstractSolutionNode getTailSolutionNode(){
		return tailSolutionNode;
	}

	public SubstitutionSet nextSolution()  throws CloneNotSupportedException 
	{
		SubstitutionSet solution;
		if(tailSolutionNode != null){
			solution = tailSolutionNode.nextSolution();
			if(solution != null)
				return solution;
		}	

		while((solution = headSolutionNode.nextSolution()) != null){

			if(operatorTail.isEmpty())
				return solution;
			else {
				tailSolutionNode = operatorTail.getSolver(getRuleSet(), solution);
				
				SubstitutionSet tailSolution = tailSolutionNode.nextSolution();
				if(tailSolution != null)
					return tailSolution;
			}
		}
		return null;
	}
}

